﻿<?php
// ============================================================
// PAINEL DE ESTATÍSTICAS DE ALUNOS (VERSÃO WEB)
// Inclui contagem separada das tabelas 'alunos' e 'matriculas', 
// e a lista de alunos sem vínculo com o botão de Eliminar.
// ============================================================

// ----------------------
// Conexão com o Banco de Dados
// ----------------------
$host = "localhost";
$user = "root";
$pass = "";
$db = "sismag";
$port = 3306; // ajuste se necessário

$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

// ----------------------
// Consultas SQL de Contagem
// ----------------------

// 1. Contagem TOTAL ÚNICO DE ALUNOS (Pessoas cadastradas) - Prioritária
$sqlTotalAlunosTable = "SELECT COUNT(*) AS total_alunos_tabela FROM alunos";
$totalAlunosTable = ($conn->query($sqlTotalAlunosTable)->fetch_assoc()['total_alunos_tabela']) ?? 0;

// 2. Contagem Total de Registros na tabela MATRICULAS (Matrículas ativas/histórico - Eventos)
$sqlTotalMatriculasTable = "SELECT COUNT(*) AS total_matriculas_tabela FROM matriculas";
$totalMatriculasTable = ($conn->query($sqlTotalMatriculasTable)->fetch_assoc()['total_matriculas_tabela']) ?? 0;

// 3. Contagem de Alunos MATRICULADOS (Join: Alunos com matrículas válidas/histórico)
$sqlTotal = "SELECT COUNT(DISTINCT a.id) AS total_alunos FROM alunos a INNER JOIN matriculas m ON a.id = m.aluno_id";
$totalAlunosMatriculados = ($conn->query($sqlTotal)->fetch_assoc()['total_alunos']) ?? 0;


// ----------------------
// NOVA CONSULTA: Alunos sem Matrícula (Cadastro Único Sem Vínculo)
// ----------------------
$sqlAlunosSemMatricula = "
    SELECT
        a.id AS aluno_id,
        a.nome,           
        a.genero,
        NULL AS turma,    
        NULL AS curso,    
        NULL AS classe,   
        NULL AS sala     
    FROM
        alunos a
    LEFT JOIN
        matriculas m ON a.id = m.aluno_id
    WHERE
        m.aluno_id IS NULL
    ORDER BY
        a.nome ASC
";
$resAlunosSemMatricula = $conn->query($sqlAlunosSemMatricula);
$totalAlunosSemMatricula = ($resAlunosSemMatricula) ? $resAlunosSemMatricula->num_rows : 0;


// ----------------------
// Consultas SQL e Agrupamento de Dados
// ----------------------

// Estatística por género
$sqlGenero = "SELECT a.genero, COUNT(*) AS total FROM alunos a INNER JOIN matriculas m ON a.id = m.aluno_id GROUP BY a.genero";
$resGenero = $conn->query($sqlGenero);

// Estatística por Idade e Género
$sqlIdadeGenero = "
    SELECT a.idade, a.genero, COUNT(*) AS total
    FROM alunos a
    INNER JOIN matriculas m ON a.id = m.aluno_id
    GROUP BY a.idade, a.genero
    ORDER BY a.idade ASC, a.genero ASC
";
$resIdadeGenero = $conn->query($sqlIdadeGenero);

$estatisticasPorIdade = [];
if ($resIdadeGenero) {
    while ($row = $resIdadeGenero->fetch_assoc()) {
        $idade = $row['idade'];
        if (!isset($estatisticasPorIdade[$idade])) {
            $estatisticasPorIdade[$idade] = ['total_idade' => 0, 'detalhes' => []];
        }
        $estatisticasPorIdade[$idade]['total_idade'] += $row['total'];
        $estatisticasPorIdade[$idade]['detalhes'][] = $row;
    }
}

// Estatística por Turma, Idade e Género
$sqlTurmaIdadeGenero = "
    SELECT t.nome AS nome_turma, a.idade, a.genero, t.classe, t.curso, t.sala, COUNT(*) AS total
    FROM alunos a
    INNER JOIN matriculas m ON a.id = m.aluno_id
    INNER JOIN turmas t ON m.turma_id = t.id
    GROUP BY t.nome, a.idade, a.genero, t.classe, t.curso, t.sala
    ORDER BY t.classe, t.curso, t.nome, a.idade, a.genero
";
$resTurmaIdadeGenero = $conn->query($sqlTurmaIdadeGenero);

$estatisticasPorTurmaAgrupada = [];
if ($resTurmaIdadeGenero) {
    while ($row = $resTurmaIdadeGenero->fetch_assoc()) {
        // Incluindo a sala na chave de agrupamento
        $turma = "{$row['classe']} - {$row['curso']} - {$row['nome_turma']} ({$row['sala']})"; 
        $idade = $row['idade'];

        if (!isset($estatisticasPorTurmaAgrupada[$turma])) {
            $estatisticasPorTurmaAgrupada[$turma] = ['total_turma' => 0, 'idades' => []];
        }
        if (!isset($estatisticasPorTurmaAgrupada[$turma]['idades'][$idade])) {
            $estatisticasPorTurmaAgrupada[$turma]['idades'][$idade] = ['total_idade' => 0, 'generos' => []];
        }

        $estatisticasPorTurmaAgrupada[$turma]['total_turma'] += $row['total'];
        $estatisticasPorTurmaAgrupada[$turma]['idades'][$idade]['total_idade'] += $row['total'];
        $estatisticasPorTurmaAgrupada[$turma]['idades'][$idade]['generos'][] = $row;
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estatística de Alunos Matriculados - SISMAG</title>
    <style>
        /* Estilos base */
        body {
            margin: 0;
            font-family: 'Inter', Arial, sans-serif;
            background: #f0f2f5;
            color: #333;
        }
        /* Barra superior */
        .topbar {
            background: #004d99; /* Azul mais escuro */
            color: white;
            padding: 15px;
            font-size: 20px;
            font-weight: bold;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        /* Barra lateral (apenas um link de exemplo, mantido por contexto) */
        .sidebar {
            background: #111827;
            width: 220px;
            height: 100vh;
            position: fixed;
            top: 50px;
            left: 0;
            padding-top: 20px;
            color: white;
            box-shadow: 2px 0 5px rgba(0,0,0,0.1);
        }
        .sidebar a {
            display: block;
            color: white;
            padding: 12px;
            text-decoration: none;
            transition: 0.3s;
            border-radius: 4px;
            margin: 5px 10px;
        }
        .sidebar a:hover {
            background: #1f2937;
        }
        /* Conteúdo principal */
        .content {
            margin-left: 230px;
            margin-top: 75px; /* Ajuste para barra superior */
            padding: 20px;
        }
        h1 {
            color: #004d99;
        }
        h2 {
            color: #004d99;
            margin-top: 30px;
            border-bottom: 2px solid #ddd;
            padding-bottom: 5px;
        }
        h3 {
            color: #555;
            margin-top: 30px;
            font-size: 1.25em;
        }
        /* Dashboard Cards para as novas métricas */
        .stats-dashboard {
            display: flex;
            gap: 20px;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }
        .stats-card {
            background: white;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            flex: 1;
            min-width: 200px;
            transition: transform 0.3s;
        }
        .stats-card:hover {
            transform: translateY(-5px);
        }
        .stats-card p {
            margin: 0;
            font-size: 14px;
            color: #666;
        }
        .stats-card .count {
            font-size: 2.2em;
            font-weight: bold;
            color: #007bff;
            margin-top: 5px;
        }
        /* Estilos dos cards ajustados para clareza */
        .stats-card.primary-total {
            border-left: 5px solid #004d99; /* Azul forte para o total único */
            background: #e6f7ff; /* Fundo levemente azulado */
        }
        .stats-card.secondary-matriculados {
            border-left: 5px solid #28a745; /* Verde para Matriculados (Join) */
        }
        .stats-card.secondary-matriculas {
            border-left: 5px solid #ffc107; /* Amarelo/Laranja para o total de registros */
        }
        /* NOVO ESTILO: Alunos sem matrícula */
        .stats-card.danger-nomatricula { 
            border-left: 5px solid #dc3545; /* Vermelho para Alunos Sem Matrícula */
            background: #fff0f0;
        }


        .print-button {
            background: #28a745;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 20px;
            transition: background 0.3s;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }
        .print-button:hover {
            background: #218838;
        }
        /* Estilos da tabela (mantidos) */
        table {
            width: 100%; /* Ajuste para 100% no conteúdo principal */
            border-collapse: collapse;
            margin-bottom: 30px;
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        th, td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: center;
        }
        th {
            background: #007bff;
            color: white;
            font-weight: bold;
        }
        .row-total-idade {
            background: #e6ffe6;
            font-weight: bold;
            color: #006600;
        }
        .row-total-turma {
            background: #cceeff;
            font-weight: bold;
            color: #004d99;
            font-size: 1.1em;
        }
        .section-header {
            background: #f0f8ff;
            font-weight: bold;
        }
        /* Linha especial para alunos sem matrícula */
        .row-sem-matricula td {
            background-color: #fcecec;
            color: #721c24;
        }
    </style>
</head>
<body>

    <div class="topbar">
        📊 Estatística de Alunos Matriculados - SISMAG
    </div>

    <div class="sidebar">
        <a href="painel_secretaria_geral.php">🏠 Início</a>
    </div>

    <div class="content">
        <h1>Estatísticas de Alunos</h1>
        
        <?php 
        // LÓGICA PARA EXIBIR MENSAGENS DE STATUS (Sucesso/Erro na exclusão)
        if (isset($_GET['status'])) {
            $status = $_GET['status'];
            $mensagem = "";
            $cor = "";

            switch ($status) {
                case 'success_delete':
                    $mensagem = "Sucesso! O aluno sem vínculo foi removido do sistema.";
                    $cor = "green";
                    break;
                case 'error_delete':
                    $mensagem = "Erro: Não foi possível remover o aluno do banco de dados.";
                    $cor = "red";
                    break;
                case 'error_vinculo':
                    $mensagem = "AVISO DE SEGURANÇA: Este aluno possui um vínculo de matrícula e a exclusão foi BLOQUEADA.";
                    $cor = "orange";
                    break;
                case 'error_invalid_id':
                    $mensagem = "Erro: ID de aluno inválido fornecido.";
                    $cor = "red";
                    break;
                default:
                    break;
            }

            if (!empty($mensagem)) {
                echo "<div style='padding: 15px; margin-bottom: 20px; border-radius: 5px; background-color: #f0f8ff; border: 1px solid #ddd;'>";
                echo "<span style='color: " . $cor . "; font-weight: bold;'>" . $mensagem . "</span>";
                echo "</div>";
            }
        }
        ?>

        <div class="stats-dashboard">
            <div class="stats-card primary-total">
                <p>Total de Alunos no Sistema (Cadastros Únicos)</p>
                <div class="count"><?php echo $totalAlunosTable; ?></div>
            </div>
            <div class="stats-card secondary-matriculados">
                <p>Alunos com Matrícula Ativa/Histórico (Com Vínculo)</p>
                <div class="count"><?php echo $totalAlunosMatriculados; ?></div>
            </div>
            <div class="stats-card danger-nomatricula">
                <p>Alunos sem Matrícula (Cadastro Sem Vínculo)</p>
                <div class="count"><?php echo $totalAlunosSemMatricula; ?></div>
            </div>
            <div class="stats-card secondary-matriculas">
                <p>Total de Registros de Matrículas (Eventos)</p>
                <div class="count"><?php echo $totalMatriculasTable; ?></div>
            </div>
        </div>
        <a href="estatistica_print.php" target="_blank" class="print-button">
              Imprimir Estatísticas (PDF)
        </a>

        ---
        
        <h2>4. Alunos no Sistema SEM Vínculo (Cadastros Únicos)</h2>
        <p>Estes alunos estão cadastrados na tabela `alunos`, mas não possuem **nenhum** registro na tabela `matriculas`. Use o botão **Eliminar** para remover estes cadastros órfãos.</p>
        
        <table>
            <tr>
                <th>ID Aluno</th>
                <th>Nome do Aluno</th>
                <th>Gênero</th>
                <th>Classe</th>
                <th>Curso</th>
                <th>Turma (Sala)</th>
                <th>Ações</th> 
            </tr>
            <?php if ($resAlunosSemMatricula && $resAlunosSemMatricula->num_rows > 0): ?>
                <?php $resAlunosSemMatricula->data_seek(0); // Reinicia o ponteiro ?>
                <?php while($row = $resAlunosSemMatricula->fetch_assoc()): ?>
                <tr class="row-sem-matricula">
                    <td><?php echo htmlspecialchars($row['aluno_id']); ?></td>
                    <td><?php echo htmlspecialchars($row['nome']); ?></td>
                    <td><?php echo htmlspecialchars($row['genero']); ?></td>
                    <td><?php echo $row['classe'] ?? 'N/A'; ?></td> 
                    <td><?php echo $row['curso'] ?? 'N/A'; ?></td>
                    <td><?php echo $row['turma'] ?? 'N/A'; ?></td>
                    
                    <td>
                        <a href="eliminar_aluno.php?id=<?php echo $row['aluno_id']; ?>" 
                           onclick="return confirm('ATENÇÃO: Tem certeza que deseja eliminar o aluno <?php echo addslashes($row['nome']); ?> (ID: <?php echo $row['aluno_id']; ?>)? Esta ação é IRREVERSÍVEL e SÓ DEVE ser feita em cadastros órfãos.');" 
                           style="background-color: #dc3545; color: white; padding: 5px 10px; border-radius: 4px; text-decoration: none; font-size: 0.9em; display: inline-block;">
                           Eliminar
                        </a>
                    </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7">Parabéns! Todos os <?php echo $totalAlunosTable; ?> alunos cadastrados possuem algum vínculo de matrícula.</td>
                </tr>
            <?php endif; ?>
        </table>

        ---

        <h2>1. Estatística por Género (Alunos Matriculados)</h2>
        <table>
            <tr>
                <th>Género</th>
                <th>Total</th>
            </tr>
            <?php if ($resGenero && $resGenero->num_rows > 0): ?>
                <?php $resGenero->data_seek(0); while($row = $resGenero->fetch_assoc()): ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['genero']); ?></td>
                    <td><?php echo htmlspecialchars($row['total']); ?></td>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="2">Sem dados disponíveis.</td></tr>
            <?php endif; ?>
        </table>
        
        ---

        <h2>2. Estatística por Idade e Género (Alunos Matriculados)</h2>
        <table>
            <tr>
                <th style="width: 30%;">Idade</th>
                <th style="width: 30%;">Género</th>
                <th style="width: 20%;">Total</th>
            </tr>
            <?php if (!empty($estatisticasPorIdade)): ?>
                <?php foreach ($estatisticasPorIdade as $idade => $dados): ?>
                    <?php
                    $rowspan = count($dados['detalhes']);
                    $isFirst = true;
                    ?>
                    <?php foreach ($dados['detalhes'] as $detalhe): ?>
                    <tr>
                        <?php if ($isFirst): ?>
                        <td rowspan="<?= $rowspan; ?>" style="vertical-align: middle; background: #f0f0f0;">
                            <?= htmlspecialchars($idade); ?> Anos
                        </td>
                        <?php $isFirst = false; endif; ?>
                        <td><?= htmlspecialchars($detalhe['genero']); ?></td>
                        <td><?= htmlspecialchars($detalhe['total']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                    <tr class="row-total-idade">
                        <td colspan="2">Total Idade <?= htmlspecialchars($idade); ?></td>
                        <td><?= htmlspecialchars($dados['total_idade']); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="3">Sem dados detalhados por idade e género disponíveis.</td></tr>
            <?php endif; ?>
        </table>
        
        ---

        <h2>3. Estatística Detalhada por Turma, Idade e Gênero (Alunos Matriculados)</h2>
        
        <?php if (!empty($estatisticasPorTurmaAgrupada)): ?>
            <?php foreach ($estatisticasPorTurmaAgrupada as $turma => $dadosTurma): ?>
                
                <h3>Turma: <?= htmlspecialchars($turma); ?> (Total: <?= $dadosTurma['total_turma']; ?>)</h3>
                
                <table>
                    <tr class="section-header">
                        <th style="width: 30%;">Idade</th>
                        <th style="width: 30%;">Género</th>
                        <th style="width: 20%;">Total</th>
                    </tr>
                    
                    <?php foreach ($dadosTurma['idades'] as $idade => $dadosIdade): ?>
                        <?php
                        $detalhes = $dadosIdade['generos'];
                        $rowspan = count($detalhes);
                        $isFirst = true;
                        ?>
                        
                        <?php foreach ($detalhes as $detalhe): ?>
                        <tr>
                            <?php if ($isFirst): ?>
                            <td rowspan="<?= $rowspan; ?>" style="vertical-align: middle; background: #f0f0f0;">
                                <?= htmlspecialchars($idade); ?> Anos
                            </td>
                            <?php $isFirst = false; endif; ?>
                            <td><?= htmlspecialchars($detalhe['genero']); ?></td>
                            <td><?= htmlspecialchars($detalhe['total']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                        
                        <tr class="row-total-idade">
                            <td colspan="2">Subtotal Idade <?= htmlspecialchars($idade); ?></td>
                            <td><?= htmlspecialchars($dadosIdade['total_idade']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    
                    <tr class="row-total-turma">
                        <td colspan="2">TOTAL GERAL DA TURMA</td>
                        <td><?= htmlspecialchars($dadosTurma['total_turma']); ?></td>
                    </tr>
                </table>
            <?php endforeach; ?>
        <?php else: ?>
            <p>Sem dados detalhados por turma, idade e género disponíveis.</p>
        <?php endif; ?>
    </div>

</body>
</html>